/* - FCAttachListener -
 * populate the fields and controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.FrequencyCounterPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FCAttachListener implements AttachListener {

    private JFrame appFrame;
    private JPanel frequencyPanel;
    private JComboBox channelCmb;
    private JComboBox filterCmb;
    private Hashtable filterTypeHashTable;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numChannelsTxt;
    private JCheckBox enableChk;
    private JTextField timeoutTxt;
    private JButton setTimeoutBtn;
    private JTextField countTxt;
    private JTextField timeTxt;
    private JTextField frequencyTxt;
    private JTextField totalCountTxt;
    private JTextField totalTimeTxt;
    private JButton resetTotalTimeAndCountBtn;

    public FCAttachListener(JFrame appFrame, JPanel frequencyPanel, JComboBox channelCmb, JComboBox filterCmb, Hashtable filterTypeHashTable, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numChannelsTxt, JCheckBox enableChk, JTextField timeoutTxt, JButton setTimeoutBtn, JTextField countTxt,
            JTextField timeTxt, JTextField frequencyTxt, JTextField totalCountTxt, JTextField totalTimeTxt, JButton resetTotalTimeAndCountBtn) {
        this.appFrame = appFrame;
        this.frequencyPanel = frequencyPanel;
        this.channelCmb = channelCmb;
        this.filterCmb = filterCmb;
        this.filterTypeHashTable = filterTypeHashTable;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numChannelsTxt = numChannelsTxt;
        this.enableChk = enableChk;
        this.timeoutTxt = timeoutTxt;
        this.setTimeoutBtn = setTimeoutBtn;
        this.countTxt = countTxt;
        this.timeTxt = timeTxt;
        this.frequencyTxt = frequencyTxt;
        this.totalCountTxt = totalCountTxt;
        this.totalTimeTxt = totalTimeTxt;
        this.resetTotalTimeAndCountBtn = resetTotalTimeAndCountBtn;
    }

    public void attached(AttachEvent an) {
        try {
            int i;
            appFrame.setSize(357, 667);

            FrequencyCounterPhidget attached = (FrequencyCounterPhidget) an.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numChannelsTxt.setText(Integer.toString(attached.getFrequencyInputCount()));

            frequencyPanel.setEnabled(true);
            frequencyPanel.setVisible(true);

            channelCmb.setEnabled(true);
            channelCmb.setVisible(true);

            for (i = 0; i < attached.getFrequencyInputCount(); i++) {
                channelCmb.addItem(new Integer(i));
            }

            filterCmb.setEnabled(true);
            filterCmb.setVisible(true);

            Enumeration e = filterTypeHashTable.keys();  
            while (e.hasMoreElements()) {
                filterCmb.addItem(e.nextElement());
  }

                  enableChk.setEnabled(true);
            enableChk.setVisible(true);

            enableChk.setSelected(attached.getEnabled(0));

            timeoutTxt.setEnabled(true);
            timeoutTxt.setVisible(true);
            countTxt.setEnabled(true);
            countTxt.setVisible(true);
            timeTxt.setEnabled(true);
            timeTxt.setVisible(true);
            frequencyTxt.setEnabled(true);
            frequencyTxt.setVisible(true);
            setTimeoutBtn.setVisible(true);
            totalCountTxt.setEnabled(true);
            totalCountTxt.setVisible(true);
            totalTimeTxt.setEnabled(true);
            totalTimeTxt.setVisible(true);
            resetTotalTimeAndCountBtn.setVisible(true);

            if (enableChk.isSelected()) {
                setTimeoutBtn.setEnabled(true);
                timeoutTxt.setText(Integer.toString(attached.getTimeout(0) / 1000));
                timeoutTxt.setEditable(true);
                totalCountTxt.setText(Long.toString(attached.getTotalCount(0)));
                totalTimeTxt.setText(Long.toString(attached.getTotalTime(0) / 1000));
                resetTotalTimeAndCountBtn.setEnabled(true);
            } else {
                filterCmb.setEnabled(false);  //cannot change filter because enabled state is false
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
